import { BrowserRouter, Routes, Route } from 'react-router';
import { ThemeProvider } from './contexts/ThemeContext';
import LandingPage from './screens/LandingPage';
import LoginPage from './screens/LoginPage';
import NDARequestForm from './screens/NDARequestForm';
import NDASubmittedPage from './screens/NDASubmittedPage';
import NDAReviewApproval from './screens/NDAReviewApproval';
import NDADocumentPage from './screens/NDADocumentPage';
import ManagerDashboard from './screens/ManagerDashboard';
import AdminDashboard from './screens/AdminDashboard';
import ManagerProfile from './screens/ManagerProfile';
import PayoutProcess from './screens/PayoutProcess';
import MonthlyKPIReport from './screens/MonthlyKPIReport';
import SettingsSecurity from './screens/SettingsSecurity';
import DesignSystem from './screens/DesignSystem';
import CreateAdminUser from './screens/CreateAdminUser';
import ImportKPIData from './screens/ImportKPIData';
import AdminKPIReports from './screens/AdminKPIReports';
import AdminManageData from './screens/AdminManageData';

export default function App() {
  return (
    <ThemeProvider>
      <BrowserRouter>
        <Routes>
          <Route path="/" element={<LandingPage />} />
          <Route path="/login" element={<LoginPage />} />
          <Route path="/design-system" element={<DesignSystem />} />
          <Route path="/nda-request" element={<NDARequestForm />} />
          <Route path="/nda-submitted" element={<NDASubmittedPage />} />
          <Route path="/admin/nda-review/:id" element={<NDAReviewApproval />} />
          <Route path="/nda-document/:id" element={<NDADocumentPage />} />
          <Route path="/manager/dashboard" element={<ManagerDashboard />} />
          <Route path="/admin/dashboard" element={<AdminDashboard />} />
          <Route path="/admin/create-user" element={<CreateAdminUser />} />
          <Route path="/admin/manage-data" element={<AdminManageData />} />
          <Route path="/admin/manager/:id" element={<ManagerProfile />} />
          <Route path="/admin/payout/:id" element={<PayoutProcess />} />
          <Route path="/admin/kpi-reports" element={<AdminKPIReports />} />
          <Route path="/admin/import-kpi-data" element={<ImportKPIData />} />
          <Route path="/kpi-report" element={<MonthlyKPIReport />} />
          <Route path="/settings" element={<SettingsSecurity />} />
        </Routes>
      </BrowserRouter>
    </ThemeProvider>
  );
}