import { motion } from 'motion/react';
import { Palette } from 'lucide-react';
import { useTheme } from '../contexts/ThemeContext';

export default function ThemeToggle() {
  const { mode, toggleTheme, primaryColor } = useTheme();

  return (
    <div className="relative">
      <button
        onClick={toggleTheme}
        className="flex items-center gap-3 text-gray-400 hover:text-white transition-colors w-full px-4 py-3 rounded-lg hover:bg-gray-800 group"
        title={`Switch to ${mode === 'site' ? 'HR' : 'Site'} Mood`}
      >
        <div className="relative">
          <Palette className="w-5 h-5" />
          <motion.div
            className="absolute -top-1 -right-1 w-3 h-3 rounded-full"
            style={{ backgroundColor: primaryColor }}
            animate={{ scale: [1, 1.2, 1] }}
            transition={{ duration: 2, repeat: Infinity }}
          />
        </div>
        <div className="flex-1 text-left">
          <span className="text-sm font-medium">
            {mode === 'site' ? '🎨 Site Mood' : '💼 HR Mood'}
          </span>
          <p className="text-xs text-gray-500 group-hover:text-gray-400">
            Click to switch
          </p>
        </div>
        
        {/* Color Preview */}
        <div className="flex gap-1">
          <motion.div
            className="w-6 h-6 rounded-full border-2 border-gray-600"
            style={{ backgroundColor: mode === 'site' ? '#8a2be2' : '#ff00d8' }}
            animate={{ scale: mode === 'site' ? 1.1 : 0.9 }}
          />
        </div>
      </button>
    </div>
  );
}
