import { useTheme } from '../contexts/ThemeContext';

// Hook to get dynamic color styles
export function useThemeColors() {
  const { primaryColor, primaryDark, mode } = useTheme();
  
  return {
    primaryColor,
    primaryDark,
    mode,
    
    // Common style objects for reuse
    bgPrimary: { backgroundColor: primaryColor },
    textPrimary: { color: primaryColor },
    borderPrimary: { borderColor: primaryColor },
    
    // Gradient backgrounds
    bgGradientPrimary: { 
      background: `linear-gradient(135deg, ${primaryColor}, ${primaryDark})` 
    },
    bgGradientPrimaryToBlack: { 
      background: `linear-gradient(to bottom right, ${primaryColor}, #000000)` 
    },
    
    // Shadows
    shadowPrimary: { 
      boxShadow: `0 10px 25px -5px ${primaryColor}80, 0 8px 10px -6px ${primaryColor}40` 
    },
    shadowPrimaryLg: { 
      boxShadow: `0 20px 40px -10px ${primaryColor}60` 
    },
    
    // Button styles
    buttonPrimary: {
      backgroundColor: primaryColor,
      boxShadow: `0 10px 25px -5px ${primaryColor}80`,
      transition: 'all 0.3s ease'
    },
    
    // Background with opacity
    bgPrimaryLight: { backgroundColor: `${primaryColor}1a` }, // 10% opacity
    bgPrimaryMedium: { backgroundColor: `${primaryColor}33` }, // 20% opacity
    
    // Border with opacity
    borderPrimaryLight: { borderColor: `${primaryColor}4d` }, // 30% opacity
  };
}