import { useState } from 'react';
import { CheckCircle, XCircle, Clock, User, TrendingUp, DollarSign, FileText, Shield, AlertCircle, Download, ArrowRight } from 'lucide-react';
import { Link } from 'react-router';
import { BrandButton, BrandLogo, BrandProgressBar, BrandBadge, BrandCard } from '../components/BrandComponents';

export default function DesignSystem() {
  const [isModalOpen, setIsModalOpen] = useState(false);

  return (
    <div className="min-h-screen bg-gray-950 p-8">
      <div className="max-w-7xl mx-auto">
        <div className="mb-12">
          <h1 className="text-white text-5xl font-bold mb-4">7starswin Design System</h1>
          <p className="text-gray-400 text-lg">
            Comprehensive component library for the Corporate HR + Legal + KPI Management System
          </p>
        </div>

        {/* Colors */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Color Palette</h2>
          <div className="grid grid-cols-4 gap-6">
            <div>
              <div className="w-full h-32 rounded-xl mb-2" style={{ background: '#450693' }}></div>
              <p className="text-white text-sm font-medium">Purple Dark</p>
              <p className="text-gray-400 text-xs">#450693</p>
              <p className="text-gray-500 text-xs mt-1">Primary Brand</p>
            </div>
            <div>
              <div className="w-full h-32 rounded-xl mb-2" style={{ background: '#8C00FF' }}></div>
              <p className="text-white text-sm font-medium">Purple Bright</p>
              <p className="text-gray-400 text-xs">#8C00FF</p>
              <p className="text-gray-500 text-xs mt-1">Accent & Gradients</p>
            </div>
            <div>
              <div className="w-full h-32 rounded-xl mb-2" style={{ background: '#FF3F7F' }}></div>
              <p className="text-white text-sm font-medium">Pink</p>
              <p className="text-gray-400 text-xs">#FF3F7F</p>
              <p className="text-gray-500 text-xs mt-1">Secondary Accent</p>
            </div>
            <div>
              <div className="w-full h-32 rounded-xl mb-2" style={{ background: '#FFC400' }}></div>
              <p className="text-white text-sm font-medium">Gold</p>
              <p className="text-gray-400 text-xs">#FFC400</p>
              <p className="text-gray-500 text-xs mt-1">Highlights & Awards</p>
            </div>
          </div>
          
          <div className="mt-8 bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
            <h3 className="text-white text-xl font-bold mb-4">Gradient Combinations</h3>
            <div className="grid grid-cols-3 gap-4">
              <div>
                <div className="w-full h-24 rounded-xl mb-2" style={{ background: 'linear-gradient(135deg, #450693 0%, #8C00FF 100%)' }}></div>
                <p className="text-gray-300 text-sm">Purple Dark → Bright</p>
              </div>
              <div>
                <div className="w-full h-24 rounded-xl mb-2" style={{ background: 'linear-gradient(135deg, #8C00FF 0%, #FF3F7F 100%)' }}></div>
                <p className="text-gray-300 text-sm">Purple → Pink</p>
              </div>
              <div>
                <div className="w-full h-24 rounded-xl mb-2" style={{ background: 'linear-gradient(135deg, #FF3F7F 0%, #FFC400 100%)' }}></div>
                <p className="text-gray-300 text-sm">Pink → Gold</p>
              </div>
            </div>
          </div>
        </section>

        {/* Buttons */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Buttons</h2>
          <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-8">
            <div className="space-y-6">
              <div>
                <p className="text-gray-400 mb-3 text-sm font-medium">Primary</p>
                <div className="flex flex-wrap gap-4">
                  <BrandButton>
                    Button / Primary / Default
                  </BrandButton>
                  <BrandButton variant="secondary">
                    Button / Secondary / Default
                  </BrandButton>
                  <BrandButton variant="outline">
                    Button / Outline / Default
                  </BrandButton>
                  <BrandButton disabled>
                    Button / Disabled
                  </BrandButton>
                </div>
              </div>

              <div>
                <p className="text-gray-400 mb-3 text-sm font-medium">With Brand Colors</p>
                <div className="flex flex-wrap gap-4">
                  <BrandButton size="sm">Small Button</BrandButton>
                  <BrandButton size="md">Medium Button</BrandButton>
                  <BrandButton size="lg">
                    Large Button <ArrowRight className="w-5 h-5" />
                  </BrandButton>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Inputs */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Input Fields</h2>
          <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-8">
            <div className="grid md:grid-cols-2 gap-6">
              <div>
                <label className="block text-white mb-2 font-medium">Input / Text / Default</label>
                <input
                  type="text"
                  className="w-full bg-gray-700/50 border border-gray-600 rounded-xl px-4 py-3 text-white focus:border-purple-500 focus:outline-none"
                  placeholder="Enter text..."
                />
              </div>

              <div>
                <label className="block text-white mb-2 font-medium">Input / Text / Focus</label>
                <input
                  type="text"
                  className="w-full bg-gray-700/50 border border-purple-500 rounded-xl px-4 py-3 text-white focus:border-purple-500 focus:outline-none"
                  placeholder="Focused state"
                />
              </div>

              <div>
                <label className="block text-white mb-2 font-medium">Input / Dropdown / Default</label>
                <select className="w-full bg-gray-700/50 border border-gray-600 rounded-xl px-4 py-3 text-white focus:border-purple-500 focus:outline-none">
                  <option>Select option...</option>
                  <option>Option 1</option>
                  <option>Option 2</option>
                </select>
              </div>

              <div>
                <label className="block text-white mb-2 font-medium">Input / DatePicker / Default</label>
                <input
                  type="date"
                  className="w-full bg-gray-700/50 border border-gray-600 rounded-xl px-4 py-3 text-white focus:border-purple-500 focus:outline-none"
                />
              </div>

              <div className="md:col-span-2">
                <label className="block text-white mb-2 font-medium">Input / Upload / Default</label>
                <div className="border-2 border-dashed border-gray-600 rounded-xl p-8 text-center hover:border-purple-500 transition-colors cursor-pointer">
                  <Upload className="w-12 h-12 text-gray-400 mx-auto mb-4" />
                  <p className="text-white font-medium mb-2">Click to upload or drag and drop</p>
                  <p className="text-gray-400 text-sm">PDF, JPG, PNG up to 10MB</p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Cards */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Cards</h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {/* KPI Card */}
            <BrandCard className="bg-gradient-to-br from-purple-600/20 to-purple-800/20 backdrop-blur-lg border border-purple-500/30 rounded-2xl p-6">
              <div className="flex items-center justify-between mb-4">
                <div className="w-12 h-12 rounded-lg bg-purple-600/30 flex items-center justify-center">
                  <TrendingUp className="w-6 h-6 text-purple-400" />
                </div>
                <span className="text-emerald-400 text-sm font-medium">+12.5%</span>
              </div>
              <p className="text-gray-400 text-sm mb-1">Card / KPI / Default</p>
              <p className="text-white text-3xl font-bold">210</p>
            </BrandCard>

            {/* Profile Card */}
            <BrandCard className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="flex items-center gap-3 mb-4">
                <div className="w-12 h-12 rounded-full bg-gradient-to-br from-purple-600 to-blue-600 flex items-center justify-center">
                  <User className="w-6 h-6 text-white" />
                </div>
                <div>
                  <p className="text-white font-semibold">John Doe</p>
                  <p className="text-gray-400 text-sm">Manager</p>
                </div>
              </div>
              <p className="text-gray-400 text-xs">Card / Profile / Default</p>
            </BrandCard>

            {/* Document Card */}
            <BrandCard className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="w-12 h-12 rounded-lg bg-amber-600/20 flex items-center justify-center mb-4">
                <FileText className="w-6 h-6 text-amber-400" />
              </div>
              <p className="text-white font-semibold mb-1">NDA Document</p>
              <p className="text-gray-400 text-sm mb-3">Card / Document / Default</p>
              <BrandButton className="text-purple-400 text-sm font-medium">View Document</BrandButton>
            </BrandCard>

            {/* Salary Card */}
            <BrandCard className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="w-12 h-12 rounded-lg bg-emerald-600/20 flex items-center justify-center mb-4">
                <DollarSign className="w-6 h-6 text-emerald-400" />
              </div>
              <p className="text-gray-400 text-sm mb-1">Card / Salary / Default</p>
              <p className="text-white text-3xl font-bold">$6,000</p>
              <p className="text-gray-400 text-xs mt-1">Per month</p>
            </BrandCard>
          </div>
        </section>

        {/* Badges */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Status Badges</h2>
          <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-8">
            <div className="flex flex-wrap gap-4">
              <BrandBadge className="px-4 py-2 rounded-lg bg-emerald-500/20 text-emerald-400 text-sm font-medium inline-flex items-center gap-2">
                <CheckCircle className="w-4 h-4" />
                Badge / Status / Approved
              </BrandBadge>
              <BrandBadge className="px-4 py-2 rounded-lg bg-yellow-500/20 text-yellow-400 text-sm font-medium inline-flex items-center gap-2">
                <Clock className="w-4 h-4" />
                Badge / Status / Pending
              </BrandBadge>
              <BrandBadge className="px-4 py-2 rounded-lg bg-red-500/20 text-red-400 text-sm font-medium inline-flex items-center gap-2">
                <XCircle className="w-4 h-4" />
                Badge / Status / Rejected
              </BrandBadge>
              <BrandBadge className="px-4 py-2 rounded-lg bg-blue-500/20 text-blue-400 text-sm font-medium inline-flex items-center gap-2">
                <CheckCircle className="w-4 h-4" />
                Badge / Status / Active
              </BrandBadge>
            </div>
          </div>
        </section>

        {/* Modals */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Modals</h2>
          <div className="grid md:grid-cols-3 gap-6">
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <h3 className="text-white font-bold mb-4">Modal / Confirmation</h3>
              <div className="space-y-3">
                <div className="flex items-center gap-3">
                  <AlertCircle className="w-6 h-6 text-yellow-400" />
                  <p className="text-white text-sm">Are you sure?</p>
                </div>
                <p className="text-gray-400 text-sm">This action cannot be undone.</p>
                <div className="flex gap-2 mt-4">
                  <BrandButton className="flex-1 px-4 py-2 rounded-lg bg-gray-700 text-white text-sm">Cancel</BrandButton>
                  <BrandButton className="flex-1 px-4 py-2 rounded-lg bg-purple-600 text-white text-sm">Confirm</BrandButton>
                </div>
              </div>
            </div>

            <div className="bg-gray-800/50 backdrop-blur-lg border border-emerald-600 rounded-2xl p-6">
              <h3 className="text-white font-bold mb-4">Modal / Success</h3>
              <div className="space-y-3">
                <div className="flex items-center gap-3">
                  <CheckCircle className="w-6 h-6 text-emerald-400" />
                  <p className="text-white text-sm">Success!</p>
                </div>
                <p className="text-gray-400 text-sm">Operation completed successfully.</p>
                <BrandButton className="w-full px-4 py-2 rounded-lg bg-emerald-600 text-white text-sm mt-4">Done</BrandButton>
              </div>
            </div>

            <div className="bg-gray-800/50 backdrop-blur-lg border border-red-600 rounded-2xl p-6">
              <h3 className="text-white font-bold mb-4">Modal / Error</h3>
              <div className="space-y-3">
                <div className="flex items-center gap-3">
                  <XCircle className="w-6 h-6 text-red-400" />
                  <p className="text-white text-sm">Error!</p>
                </div>
                <p className="text-gray-400 text-sm">Something went wrong.</p>
                <BrandButton className="w-full px-4 py-2 rounded-lg bg-red-600 text-white text-sm mt-4">Try Again</BrandButton>
              </div>
            </div>
          </div>
        </section>

        {/* NDA Components */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">NDA Components</h2>
          <div className="space-y-6">
            {/* Progress Bar */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-8">
              <p className="text-white font-semibold mb-4">NDA / ProgressBar / Default</p>
              <BrandProgressBar className="w-full h-2 bg-gray-700 rounded-full overflow-hidden" value={60}>
                <div className="h-full bg-gradient-to-r from-purple-600 to-purple-400 rounded-full" style={{ width: '60%' }}></div>
              </BrandProgressBar>
              <div className="flex justify-between mt-2">
                <span className="text-purple-400 text-sm">Step 1</span>
                <span className="text-purple-400 text-sm">Step 2</span>
                <span className="text-purple-400 text-sm">Step 3</span>
                <span className="text-gray-500 text-sm">Step 4</span>
              </div>
            </div>

            {/* Security Notice */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-8">
              <div className="bg-purple-500/10 border border-purple-500/30 rounded-xl p-4">
                <p className="text-purple-300 text-sm">
                  <strong>🔒 NDA / SecurityNotice / Default:</strong> All information provided is encrypted and treated with strict confidentiality.
                </p>
              </div>
            </div>

            {/* Disclaimer */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-8">
              <div className="bg-yellow-500/10 border border-yellow-500/30 rounded-xl p-4">
                <p className="text-yellow-400 text-sm">
                  <strong>⚠️ NDA / Disclaimer / Default:</strong> This is not legal advice. Consult with qualified legal professionals before signing.
                </p>
              </div>
            </div>
          </div>
        </section>

        {/* Navigation */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Navigation</h2>
          <div className="grid md:grid-cols-2 gap-6">
            {/* Sidebar Example */}
            <div className="bg-gray-900 border border-gray-800 rounded-2xl p-4">
              <p className="text-gray-400 text-sm mb-4">Navbar / Sidebar / Default</p>
              <div className="space-y-2">
                <div className="flex items-center gap-3 px-4 py-3 rounded-lg bg-purple-600 text-white">
                  <TrendingUp className="w-5 h-5" />
                  <span className="font-medium">Dashboard</span>
                </div>
                <div className="flex items-center gap-3 px-4 py-3 rounded-lg text-gray-400 hover:bg-gray-800">
                  <FileText className="w-5 h-5" />
                  <span className="font-medium">NDA Requests</span>
                </div>
                <div className="flex items-center gap-3 px-4 py-3 rounded-lg text-gray-400 hover:bg-gray-800">
                  <DollarSign className="w-5 h-5" />
                  <span className="font-medium">Payroll</span>
                </div>
              </div>
            </div>

            {/* Topbar Example */}
            <div className="bg-gray-900 border border-gray-800 rounded-2xl p-4">
              <p className="text-gray-400 text-sm mb-4">Navbar / Topbar / Default</p>
              <div className="flex items-center justify-between">
                <div>
                  <h3 className="text-white font-bold">Dashboard</h3>
                  <p className="text-gray-400 text-sm">Welcome back</p>
                </div>
                <div className="flex items-center gap-4">
                  <BrandButton className="p-2 rounded-lg bg-gray-800 relative">
                    <Shield className="w-5 h-5 text-gray-400" />
                    <span className="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                  </BrandButton>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Dashboard Components */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Dashboard Components</h2>
          <div className="space-y-6">
            {/* Notification Item */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <p className="text-white font-semibold mb-4">Dashboard / Notification / Item</p>
              <div className="p-4 bg-gray-900/50 rounded-xl">
                <div className="flex items-start gap-3">
                  <div className="w-2 h-2 rounded-full bg-emerald-400 mt-1.5"></div>
                  <div className="flex-1">
                    <p className="text-white text-sm">Your NDA has been approved</p>
                    <p className="text-gray-500 text-xs mt-1">2 hours ago</p>
                  </div>
                </div>
              </div>
            </div>

            {/* Table Row */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6 overflow-x-auto">
              <p className="text-white font-semibold mb-4">Dashboard / Table / Managers</p>
              <table className="w-full">
                <thead>
                  <tr className="border-b border-gray-700">
                    <th className="text-left text-gray-400 text-sm font-medium pb-3">Name</th>
                    <th className="text-left text-gray-400 text-sm font-medium pb-3">Country</th>
                    <th className="text-left text-gray-400 text-sm font-medium pb-3">Status</th>
                    <th className="text-left text-gray-400 text-sm font-medium pb-3">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <tr className="border-b border-gray-700/50">
                    <td className="py-3 text-white">John Doe</td>
                    <td className="py-3 text-gray-300">USA</td>
                    <td className="py-3">
                      <span className="px-3 py-1 rounded-lg bg-emerald-500/20 text-emerald-400 text-xs">Approved</span>
                    </td>
                    <td className="py-3">
                      <BrandButton className="px-3 py-1 rounded-lg bg-purple-600 text-white text-xs">View</BrandButton>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </section>

        {/* User Flow Documentation */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">User Flows</h2>
          <div className="grid md:grid-cols-2 gap-6">
            {/* Manager Flow */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <h3 className="text-white text-xl font-bold mb-4 flex items-center gap-2">
                <User className="w-5 h-5 text-purple-400" />
                Manager Flow
              </h3>
              <div className="space-y-3">
                {[
                  'Landing Page',
                  'Login',
                  'NDA Request Form (4 Steps)',
                  'Manager Dashboard',
                  'KPI Reports',
                  'Settings & Security'
                ].map((step, index) => (
                  <div key={index} className="flex items-center gap-3">
                    <div className="w-6 h-6 rounded-full bg-purple-600 flex items-center justify-center text-white text-xs font-bold">
                      {index + 1}
                    </div>
                    <p className="text-gray-300 text-sm">{step}</p>
                  </div>
                ))}
              </div>
            </div>

            {/* Admin Flow */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <h3 className="text-white text-xl font-bold mb-4 flex items-center gap-2">
                <Shield className="w-5 h-5 text-blue-400" />
                Admin Flow
              </h3>
              <div className="space-y-3">
                {[
                  'Admin Dashboard',
                  'Review Pending NDAs',
                  'Approve/Reject NDA',
                  'Generate NDA Document',
                  'Manager Profile View',
                  'Process Payout'
                ].map((step, index) => (
                  <div key={index} className="flex items-center gap-3">
                    <div className="w-6 h-6 rounded-full bg-blue-600 flex items-center justify-center text-white text-xs font-bold">
                      {index + 1}
                    </div>
                    <p className="text-gray-300 text-sm">{step}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </section>

        {/* Quick Links */}
        <section className="mb-16">
          <h2 className="text-white text-3xl font-bold mb-6">Quick Navigation</h2>
          <div className="grid md:grid-cols-3 gap-4">
            <Link to="/" className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-xl p-4 hover:border-purple-500 transition-colors">
              <p className="text-white font-semibold mb-1">Landing Page</p>
              <p className="text-gray-400 text-sm">View the home page</p>
            </Link>
            <Link to="/login" className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-xl p-4 hover:border-purple-500 transition-colors">
              <p className="text-white font-semibold mb-1">Manager Login</p>
              <p className="text-gray-400 text-sm">Manager authentication</p>
            </Link>
            <Link to="/nda-request" className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-xl p-4 hover:border-purple-500 transition-colors">
              <p className="text-white font-semibold mb-1">NDA Request Form</p>
              <p className="text-gray-400 text-sm">Multi-step form</p>
            </Link>
            <Link to="/manager/dashboard" className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-xl p-4 hover:border-purple-500 transition-colors">
              <p className="text-white font-semibold mb-1">Manager Dashboard</p>
              <p className="text-gray-400 text-sm">Manager portal</p>
            </Link>
            <Link to="/admin/dashboard" className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-xl p-4 hover:border-purple-500 transition-colors">
              <p className="text-white font-semibold mb-1">Admin Dashboard</p>
              <p className="text-gray-400 text-sm">Admin portal</p>
            </Link>
            <Link to="/kpi-report" className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-xl p-4 hover:border-purple-500 transition-colors">
              <p className="text-white font-semibold mb-1">KPI Reports</p>
              <p className="text-gray-400 text-sm">Performance analytics</p>
            </Link>
          </div>
        </section>
      </div>
    </div>
  );
}

// Add Upload icon component since it's missing
function Upload({ className }: { className?: string }) {
  return (
    <svg className={className} fill="none" viewBox="0 0 24 24" stroke="currentColor">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
    </svg>
  );
}