import { Link } from 'react-router';
import { motion } from 'motion/react';
import { Shield, Lock, FileCheck, TrendingUp, DollarSign, Users, CheckCircle, ArrowRight, Award, Globe, Zap, Clock, BarChart3, UserCheck, Star, Play, Quote, Briefcase, Target } from 'lucide-react';
import LegalFooter from '../components/LegalFooter';
import { useThemeColors } from '../hooks/useThemeColors';

export default function LandingPage() {
  const { primaryColor, primaryDark, bgPrimary, textPrimary, shadowPrimary, buttonPrimary, bgGradientPrimaryToBlack } = useThemeColors();
  
  return (
    <div className="min-h-screen bg-black overflow-x-hidden">
      {/* Navigation */}
      <nav className="fixed top-0 w-full bg-black/95 backdrop-blur-lg border-b border-gray-800 z-50 shadow-sm">
        <div className="max-w-7xl mx-auto px-6 py-4 flex items-center justify-between">
          <div className="flex items-center gap-4">
            {/* Logo - Can be replaced with actual image */}
            <div className="flex items-center gap-3">
              <img 
                src={`https://via.placeholder.com/50x50/${primaryColor.slice(1)}/ffffff?text=7S`} 
                alt="7starswin Logo" 
                className="w-12 h-12 rounded-xl"
              />
              <div>
                <span className="text-2xl font-bold text-white">
                  7starswin
                </span>
                <p className="text-xs text-gray-400 font-medium">Affiliate Partner Network</p>
              </div>
            </div>
          </div>
          <div className="flex items-center gap-4">
            <Link
              to="/login"
              className="text-gray-300 hover:text-white transition-colors px-5 py-2 font-medium"
            >
              Manager Login
            </Link>
            <Link
              to="/nda-request"
              className="text-white px-6 py-3 rounded-xl font-semibold transition-all shadow-lg"
              style={{ 
                backgroundColor: primaryColor,
                boxShadow: `0 10px 25px -5px ${primaryColor}80`
              }}
            >
              Join Our Team
            </Link>
          </div>
        </div>
      </nav>

      {/* Hero Section */}
      <section className="relative min-h-screen flex items-center justify-center overflow-hidden pt-20">
        {/* Background Image with Overlay */}
        <div className="absolute inset-0">
          <img 
            src="https://images.unsplash.com/photo-1646153114001-495dfb56506d?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxtb2Rlcm4lMjBvZmZpY2UlMjB3b3Jrc3BhY2UlMjB0ZWNobm9sb2d5fGVufDF8fHx8MTc3MTg1NDAxMXww&ixlib=rb-4.1.0&q=80&w=1080"
            alt="Modern Office"
            className="w-full h-full object-cover opacity-10"
          />
          <div className="absolute inset-0 bg-gradient-to-br from-black via-gray-900 to-black opacity-95" />
        </div>

        {/* Animated Background Elements */}
        <div className="absolute inset-0 overflow-hidden">
          <motion.div
            className="absolute top-20 left-10 w-64 h-64 rounded-full bg-[#8a2be2]/30 blur-3xl"
            animate={{
              y: [0, 50, 0],
              scale: [1, 1.2, 1],
              rotate: [0, 90, 0],
            }}
            transition={{
              duration: 8,
              repeat: Infinity,
              ease: "easeInOut",
            }}
          />
          <motion.div
            className="absolute bottom-20 right-10 w-96 h-96 rounded-full bg-white/10 blur-3xl"
            animate={{
              y: [0, -50, 0],
              scale: [1.2, 1, 1.2],
              rotate: [90, 0, 90],
            }}
            transition={{
              duration: 10,
              repeat: Infinity,
              ease: "easeInOut",
            }}
          />
          
          {/* Floating Particles */}
          {[...Array(20)].map((_, i) => (
            <motion.div
              key={i}
              className="absolute w-2 h-2 rounded-full bg-[#8a2be2]"
              style={{
                left: `${Math.random() * 100}%`,
                top: `${Math.random() * 100}%`,
              }}
              animate={{
                y: [0, -30, 0],
                opacity: [0.3, 0.9, 0.3],
                scale: [1, 1.5, 1],
              }}
              transition={{
                duration: 3 + Math.random() * 2,
                repeat: Infinity,
                delay: Math.random() * 2,
              }}
            />
          ))}
        </div>

        <div className="max-w-7xl mx-auto px-6 grid md:grid-cols-2 gap-12 items-center relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 30 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.8 }}
          >
            <motion.div
              className="inline-flex items-center gap-2 mb-6 px-4 py-2 rounded-full bg-[#8a2be2]/10 border border-[#8a2be2]/30"
              initial={{ opacity: 0, scale: 0.8 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: 0.2 }}
            >
              <Briefcase className="w-4 h-4 text-[#8a2be2]" />
              <span className="text-[#8a2be2] font-semibold text-sm">Join 7starswin Affiliate Network</span>
            </motion.div>
            
            <motion.h1 
              className="text-5xl md:text-7xl font-extrabold mb-6 leading-tight bg-[#fff8f800]"
              initial={{ opacity: 0, y: 30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.8, delay: 0.3 }}
            >
              <motion.span 
                className="inline-block text-[#8a2be2]"
                style={{
                  textShadow: '0 0 40px rgba(138, 43, 226, 0.5), 0 0 80px rgba(138, 43, 226, 0.3)',
                  filter: 'drop-shadow(0 4px 20px rgba(138, 43, 226, 0.4))'
                }}
                animate={{
                  textShadow: [
                    '0 0 40px rgba(138, 43, 226, 0.5), 0 0 80px rgba(138, 43, 226, 0.3)',
                    '0 0 60px rgba(138, 43, 226, 0.7), 0 0 100px rgba(138, 43, 226, 0.5)',
                    '0 0 40px rgba(138, 43, 226, 0.5), 0 0 80px rgba(138, 43, 226, 0.3)',
                  ]
                }}
                transition={{
                  duration: 3,
                  repeat: Infinity,
                  ease: "easeInOut"
                }}
              >
                Become a
              </motion.span>
              <br />
              <motion.span 
                className="inline-block bg-gradient-to-r from-white via-gray-100 to-white bg-clip-text text-transparent"
                initial={{ opacity: 0, x: -20 }}
                animate={{ 
                  opacity: 1, 
                  x: 0,
                  backgroundPosition: ['0% 50%', '100% 50%', '0% 50%']
                }}
                transition={{ 
                  opacity: { duration: 0.8, delay: 0.5 },
                  x: { duration: 0.8, delay: 0.5 },
                  backgroundPosition: { duration: 5, repeat: Infinity, ease: "linear" }
                }}
                style={{
                  backgroundSize: '200% 200%',
                  filter: 'drop-shadow(0 2px 10px rgba(255, 255, 255, 0.3))'
                }}
              >
                7starswin Leader
              </motion.span>
            </motion.h1>
            
            <p className="text-gray-300 text-xl mb-8 leading-relaxed">
              Join our exclusive affiliate manager network for gaming and sports betting. Manage your performance, 
              track KPIs in real-time, and earn competitive payouts through our professional management system.
            </p>
            
            <div className="flex flex-wrap gap-4">
              <Link
                to="/nda-request"
                className="group bg-[#8a2be2] hover:bg-[#7a1fd2] text-white px-8 py-4 rounded-2xl font-bold transition-all shadow-xl shadow-[#8a2be2]/50 flex items-center gap-3 text-lg"
              >
                Apply Now
                <ArrowRight className="w-5 h-5 group-hover:translate-x-1 transition-transform" />
              </Link>
              <Link
                to="/login"
                className="group bg-white hover:bg-gray-50 text-gray-900 px-8 py-4 rounded-2xl font-bold transition-all border-2 border-gray-200 shadow-lg flex items-center gap-2"
              >
                <Users className="w-5 h-5 text-[#8a2be2]" />
                Manager Portal
              </Link>
            </div>

            {/* Stats */}
            <div className="grid grid-cols-3 gap-6 mt-12">
              <motion.div
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: 0.4 }}
                className="text-center"
              >
                <p className="text-4xl font-bold text-[#8a2be2]">500+</p>
                <p className="text-gray-400 text-sm mt-1">Active Managers</p>
              </motion.div>
              <motion.div
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: 0.5 }}
                className="text-center"
              >
                <p className="text-4xl font-bold text-[#8a2be2]">$2M+</p>
                <p className="text-gray-400 text-sm mt-1">Paid Monthly</p>
              </motion.div>
              <motion.div
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: 0.6 }}
                className="text-center"
              >
                <p className="text-4xl font-bold text-[#8a2be2]">MON-FRI</p>
                <p className="text-gray-400 text-sm mt-1">Support</p>
              </motion.div>
            </div>
          </motion.div>

          {/* 3D Animated Cards */}
          <motion.div
            initial={{ opacity: 0, scale: 0.8 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.8 }}
            className="relative"
          >
            <div className="relative" style={{ perspective: '1000px' }}>
              {/* Main Card */}
              <motion.div
                className="relative bg-white rounded-3xl shadow-2xl p-8 border border-[#8a2be2]/20"
                style={{ transformStyle: 'preserve-3d' }}
                animate={{
                  rotateY: [0, 5, 0, -5, 0],
                  rotateX: [0, 2, 0, -2, 0],
                }}
                transition={{
                  duration: 8,
                  repeat: Infinity,
                  ease: "easeInOut",
                }}
              >
                <div className="space-y-6">
                  {/* KPI Card */}
                  <motion.div
                    className="relative bg-gradient-to-br from-[#8a2be2] to-black rounded-2xl p-6 text-white overflow-hidden"
                    whileHover={{ scale: 1.05, z: 50 }}
                    style={{ transformStyle: 'preserve-3d' }}
                  >
                    <div className="absolute inset-0 opacity-20">
                      <img 
                        src="https://images.unsplash.com/photo-1770681381576-f1fdceb2ea01?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxkYXRhJTIwdmlzdWFsaXphdGlvbiUyMGNoYXJ0cyUyMGdyYXBoc3xlbnwxfHx8fDE3NzE4MjI3MDd8MA&ixlib=rb-4.1.0&q=80&w=1080"
                        alt="Charts"
                        className="w-full h-full object-cover"
                      />
                    </div>
                    <div className="relative z-10">
                      <div className="flex items-center justify-between mb-4">
                        <div className="flex items-center gap-3">
                          <div className="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center">
                            <TrendingUp className="w-6 h-6" />
                          </div>
                          <div>
                            <p className="text-sm opacity-90">Your Performance</p>
                            <p className="text-2xl font-bold">+127%</p>
                          </div>
                        </div>
                        <BarChart3 className="w-8 h-8 opacity-50" />
                      </div>
                      <div className="h-2 bg-white/20 rounded-full overflow-hidden">
                        <motion.div
                          className="h-full bg-white rounded-full"
                          initial={{ width: "0%" }}
                          animate={{ width: "85%" }}
                          transition={{ duration: 2, delay: 1 }}
                        />
                      </div>
                    </div>
                  </motion.div>

                  {/* NDA Status Card */}
                  <motion.div
                    className="bg-gradient-to-br from-white to-gray-50 rounded-2xl p-6 border border-[#8a2be2]/30"
                    whileHover={{ scale: 1.05, z: 50 }}
                    style={{ transformStyle: 'preserve-3d' }}
                  >
                    <div className="flex items-center gap-4 mb-4">
                      <div className="w-12 h-12 rounded-xl bg-[#8a2be2] flex items-center justify-center">
                        <FileCheck className="w-6 h-6 text-white" />
                      </div>
                      <div>
                        <p className="text-gray-600 text-sm">Contract Status</p>
                        <p className="text-gray-900 font-bold text-lg">Approved</p>
                      </div>
                      <CheckCircle className="ml-auto w-6 h-6 text-emerald-500" />
                    </div>
                    <div className="flex gap-2">
                      <span className="px-3 py-1 rounded-lg bg-[#8a2be2]/10 text-[#8a2be2] text-xs font-semibold">Active</span>
                      <span className="px-3 py-1 rounded-lg bg-black/10 text-black text-xs font-semibold">Verified</span>
                    </div>
                  </motion.div>

                  {/* Payout Card */}
                  <motion.div
                    className="bg-gradient-to-br from-black to-[#8a2be2] rounded-2xl p-6 text-white"
                    whileHover={{ scale: 1.05, z: 50 }}
                    style={{ transformStyle: 'preserve-3d' }}
                  >
                    <div className="flex items-center justify-between">
                      <div className="flex items-center gap-3">
                        <div className="w-12 h-12 rounded-xl bg-white/20 backdrop-blur-sm flex items-center justify-center">
                          <DollarSign className="w-6 h-6" />
                        </div>
                        <div>
                          <p className="text-sm opacity-90">Next Payout</p>
                          <p className="text-3xl font-bold">$6,000</p>
                        </div>
                      </div>
                      <Clock className="w-8 h-8 opacity-50" />
                    </div>
                  </motion.div>
                </div>
              </motion.div>

              {/* Floating Elements */}
              <motion.div
                className="absolute -top-4 -right-4 w-24 h-24 rounded-2xl bg-gradient-to-br from-[#8a2be2] to-black shadow-xl"
                animate={{
                  y: [0, -20, 0],
                  rotate: [0, 180, 360],
                }}
                transition={{
                  duration: 6,
                  repeat: Infinity,
                  ease: "easeInOut",
                }}
                style={{ transformStyle: 'preserve-3d' }}
              >
                <div className="w-full h-full flex items-center justify-center">
                  <Award className="w-12 h-12 text-white" />
                </div>
              </motion.div>

              <motion.div
                className="absolute -bottom-4 -left-4 w-20 h-20 rounded-xl bg-gradient-to-br from-black to-[#8a2be2] shadow-xl"
                animate={{
                  y: [0, 20, 0],
                  rotate: [360, 180, 0],
                }}
                transition={{
                  duration: 5,
                  repeat: Infinity,
                  ease: "easeInOut",
                }}
                style={{ transformStyle: 'preserve-3d' }}
              >
                <div className="w-full h-full flex items-center justify-center">
                  <Target className="w-10 h-10 text-white" />
                </div>
              </motion.div>
            </div>
          </motion.div>
        </div>
      </section>

      {/* Why Join Section */}
      <section className="py-24 bg-black relative">
        <div className="max-w-7xl mx-auto px-6">
          <div className="text-center mb-16">
            <motion.span
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              className="inline-block px-4 py-2 rounded-full bg-[#8a2be2]/10 border border-[#8a2be2]/30 text-[#8a2be2] font-semibold text-sm mb-4"
            >
              Why Choose 7starswin
            </motion.span>
            <h2 className="text-5xl font-bold mb-4">
              <span className="text-white">Benefits of Working</span>
              <br />
              <span className="text-[#8a2be2]">With Our Network</span>
            </h2>
            <p className="text-gray-400 text-xl max-w-3xl mx-auto">
              We provide our affiliate managers with industry-leading tools, support, and compensation
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {[
              {
                icon: DollarSign,
                title: "Competitive Payouts",
                description: "Earn top-tier commissions with transparent payment terms. Monthly payouts processed on time, every time.",
                image: "https://images.unsplash.com/photo-1739298061766-e2751d92e9db?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxidXNpbmVzcyUyMHN1Y2Nlc3MlMjBjZWxlYnJhdGlvbiUyMHRlYW18ZW58MXx8fHwxNzcxODU5Nzk3fDA&ixlib=rb-4.1.0&q=80&w=1080"
              },
              {
                icon: TrendingUp,
                title: "Real-Time KPI Dashboard",
                description: "Track your FTD, deposits, and partner metrics instantly. Full transparency into your performance 24/7.",
                image: "https://images.unsplash.com/photo-1759752394755-1241472b589d?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxkYXNoYm9hcmQlMjBhbmFseXRpY3MlMjBzY3JlZW4lMjBsYXB0b3B8ZW58MXx8fHwxNzcxOTE3NTkzfDA&ixlib=rb-4.1.0&q=80&w=1080"
              },
              {
                icon: Shield,
                title: "Secure & Professional",
                description: "Work with a legitimate, compliant organization. All contracts protected by NDA with full legal backing.",
                image: "https://images.unsplash.com/photo-1760246964044-1384f71665b9?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxjb3Jwb3JhdGUlMjBvZmZpY2UlMjBidWlsZGluZyUyMG1vZGVybnxlbnwxfHx8fDE3NzE5MTc1ODl8MA&ixlib=rb-4.1.0&q=80&w=1080"
              },
              {
                icon: Users,
                title: "Dedicated Support",
                description: "24/7 manager support from our HR team. Get help whenever you need it via multiple channels.",
                image: "https://images.unsplash.com/photo-1758518731468-98e90ffd7430?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxkaXZlcnNlJTIwYnVzaW5lc3MlMjBwcm9mZXNzaW9uYWxzJTIwY29ycG9yYXRlfGVufDF8fHx8MTc3MTkxNzU4OHww&ixlib=rb-4.1.0&q=80&w=1080"
              },
              {
                icon: FileCheck,
                title: "Simple Onboarding",
                description: "Quick NDA approval process. Start working within 24-48 hours after document verification.",
                image: "https://images.unsplash.com/photo-1769740333462-9a63bfa914bc?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxwcm9mZXNzaW9uYWwlMjBidXNpbmVzcyUyMHRlYW0lMjBtZWV0aW5nJTIwb2ZmaWNlfGVufDF8fHx8MTc3MTg4MDI0NXww&ixlib=rb-4.1.0&q=80&w=1080"
              },
              {
                icon: Globe,
                title: "Global Opportunities",
                description: "Work from anywhere in the world. We support managers across multiple countries and time zones.",
                image: "https://images.unsplash.com/photo-1646153114001-495dfb56506d?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxtb2Rlcm4lMjBvZmZpY2UlMjB3b3Jrc3BhY2UlMjB0ZWNobm9sb2d5fGVufDF8fHx8MTc3MTg1NDAxMXww&ixlib=rb-4.1.0&q=80&w=1080"
              },
            ].map((benefit, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 30 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
                whileHover={{ y: -10, scale: 1.02 }}
                className="group relative bg-white rounded-3xl overflow-hidden border-2 border-gray-100 hover:border-[#8a2be2]/50 transition-all shadow-lg hover:shadow-2xl"
              >
                {/* Image */}
                <div className="relative h-48 overflow-hidden">
                  <img 
                    src={benefit.image}
                    alt={benefit.title}
                    className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500"
                  />
                  <div className="absolute inset-0 bg-gradient-to-br from-[#8a2be2]/70 to-black/70 group-hover:from-[#8a2be2]/50 group-hover:to-black/50 transition-all" />
                  <motion.div
                    className="absolute inset-0 flex items-center justify-center"
                    whileHover={{ scale: 1.2, rotate: 360 }}
                    transition={{ duration: 0.6 }}
                  >
                    <div className="w-16 h-16 rounded-2xl bg-white/90 backdrop-blur-sm flex items-center justify-center shadow-xl">
                      <benefit.icon className="w-8 h-8 text-[#8a2be2]" />
                    </div>
                  </motion.div>
                </div>

                <div className="p-8">
                  <h3 className="text-xl font-bold text-gray-900 mb-3">{benefit.title}</h3>
                  <p className="text-gray-600 leading-relaxed">{benefit.description}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Manager Testimonials */}
      <section className="py-24 bg-gray-900 relative overflow-hidden">
        <div className="absolute inset-0 opacity-20">
          <div className="absolute top-0 left-1/4 w-96 h-96 bg-[#8a2be2]/30 rounded-full blur-3xl" />
          <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-white/10 rounded-full blur-3xl" />
        </div>

        <div className="max-w-7xl mx-auto px-6 relative z-10">
          <div className="text-center mb-16">
            <motion.span
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              className="inline-block px-4 py-2 rounded-full bg-[#8a2be2]/10 text-[#8a2be2] font-semibold text-sm mb-4 shadow-lg border border-[#8a2be2]/30"
            >
              Success Stories
            </motion.span>
            <h2 className="text-5xl font-bold mb-4">
              <span className="text-[#8a2be2]">
                What Our Managers Say
              </span>
            </h2>
            <p className="text-gray-400 text-xl">Real feedback from our active affiliate managers</p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {[
              {
                name: "Sarah Mitchell",
                role: "Affiliate Manager",
                location: "United Kingdom",
                image: "https://images.unsplash.com/photo-1689600944138-da3b150d9cb8?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxwcm9mZXNzaW9uYWwlMjBoZWFkc2hvdCUyMGJ1c2luZXNzJTIwb21hbml0eSUyMGJ1c2luZXNzJTIwY29uc3VsdGFudHxlbnwxfHx8fDE3NzE5MTc1OTJ8MA&ixlib=rb-4.1.0&q=80&w=1080",
                testimonial: "Working with 7starswin has been incredible. The KPI dashboard makes tracking my performance effortless, and payouts are always on time!",
                earnings: "$8.5K/month",
              },
              {
                name: "Michael Chen",
                role: "Senior Affiliate Manager",
                location: "Singapore",
                image: "https://images.unsplash.com/photo-1652471943570-f3590a4e52ed?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxwcm9mZXNzaW9uYWwlMjBoZWFkc2hvdCUyMGJ1c2luZXNzJTIwbWFuJTIwc3VpdHxlbnwxfHx8fDE3NzE5MTc1OTJ8MA&ixlib=rb-4.1.0&q=80&w=1080",
                testimonial: "Best affiliate network I've worked with. Professional management, transparent reporting, and the support team is available whenever I need help.",
                earnings: "$3.5K/month",
              },
              {
                name: "Emma Rodriguez",
                role: "Affiliate Manager",
                location: "Spain",
                image: "https://images.unsplash.com/photo-1736939678218-bd648b5ef3bb?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxociUyMG1hbmFnZXIlMjBwcm9mZXNzaW9uYWwlMjB3b21hbnxlbnwxfHx8fDE3NzE5MTc1ODh8MA&ixlib=rb-4.1.0&q=80&w=1080",
                testimonial: "The onboarding process was smooth and quick. I started earning within my first week. Highly recommend joining their team!",
                earnings: "$6.8K/month",
              },
            ].map((testimonial, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 30 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5, delay: index * 0.2 }}
                whileHover={{ y: -10, scale: 1.02 }}
                className="bg-white rounded-3xl p-8 shadow-xl border-2 border-[#8a2be2]/20 relative"
              >
                <Quote className="w-10 h-10 text-[#8a2be2] opacity-30 mb-4" />
                <p className="text-gray-700 leading-relaxed mb-6 italic">
                  "{testimonial.testimonial}"
                </p>
                
                <div className="flex items-center gap-1 mb-6">
                  {[...Array(5)].map((_, i) => (
                    <Star key={i} className="w-5 h-5 fill-[#8a2be2] text-[#8a2be2]" />
                  ))}
                </div>

                <div className="flex items-center gap-4 pb-4 border-b border-gray-200">
                  <img 
                    src={testimonial.image}
                    alt={testimonial.name}
                    className="w-14 h-14 rounded-full object-cover border-2 border-[#8a2be2]/30"
                  />
                  <div>
                    <p className="font-bold text-gray-900">{testimonial.name}</p>
                    <p className="text-sm text-gray-600">{testimonial.role}</p>
                    <p className="text-xs text-gray-500">{testimonial.location}</p>
                  </div>
                </div>
                
                <div className="mt-4 text-center">
                  <p className="text-sm text-gray-500">Average Earnings</p>
                  <p className="text-2xl font-bold text-[#8a2be2]">{testimonial.earnings}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* How to Join */}
      <section className="py-24 bg-black relative">
        <div className="max-w-7xl mx-auto px-6 relative z-10">
          <div className="text-center mb-16">
            <motion.span
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              className="inline-block px-4 py-2 rounded-full bg-[#8a2be2]/10 border border-[#8a2be2]/30 text-[#8a2be2] font-semibold text-sm mb-4"
            >
              Application Process
            </motion.span>
            <h2 className="text-5xl font-bold mb-4">
              <span className="text-[#8a2be2]">
                How to Join 7starswin
              </span>
            </h2>
            <p className="text-gray-400 text-xl">Start your journey in 3 simple steps</p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {[
              {
                step: "01",
                title: "Submit NDA Request",
                description: "Fill out our secure application form with your details. Takes less than 5 minutes to complete.",
                icon: FileCheck,
              },
              {
                step: "02",
                title: "HR Review & Approval",
                description: "Our HR team reviews your application and verifies your information within 24-48 hours.",
                icon: UserCheck,
              },
              {
                step: "03",
                title: "Start Earning",
                description: "Get access to your manager dashboard, start tracking your KPIs, and receive your first payout.",
                icon: Target,
              },
            ].map((step, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 30 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5, delay: index * 0.2 }}
                className="relative"
              >
                <div className="bg-white rounded-3xl p-8 shadow-xl border-2 border-[#8a2be2]/20 hover:border-[#8a2be2]/50 transition-all">
                  <div className="absolute -top-6 left-8">
                    <div className="w-12 h-12 rounded-xl bg-[#8a2be2] flex items-center justify-center text-white font-bold text-xl shadow-lg">
                      {step.step}
                    </div>
                  </div>
                  <div className="mt-8">
                    <div className="w-16 h-16 rounded-2xl bg-[#8a2be2]/10 flex items-center justify-center mb-6">
                      <step.icon className="w-8 h-8 text-[#8a2be2]" />
                    </div>
                    <h3 className="text-2xl font-bold text-gray-900 mb-3">{step.title}</h3>
                    <p className="text-gray-600 leading-relaxed">{step.description}</p>
                  </div>
                </div>
                
                {/* Connector Line */}
                {index < 2 && (
                  <motion.div 
                    className="hidden md:block absolute top-1/2 -right-4 w-8 h-0.5 bg-[#8a2be2]/30 z-0"
                    initial={{ scaleX: 0 }}
                    whileInView={{ scaleX: 1 }}
                    transition={{ duration: 0.8, delay: 0.5 + index * 0.2 }}
                  />
                )}
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-24 relative overflow-hidden">
        <div className="absolute inset-0">
          <img 
            src="https://images.unsplash.com/photo-1769740333462-9a63bfa914bc?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxwcm9mZXNzaW9uYWwlMjBidXNpbmVzcyUyMHRlYW0lMjBtZWV0aW5nJTIwb2ZmaWNlfGVufDF8fHx8MTc3MTg4MDI0NXww&ixlib=rb-4.1.0&q=80&w=1080"
            alt="Team"
            className="w-full h-full object-cover"
          />
          <div className="absolute inset-0 bg-gradient-to-br from-[#8a2be2]/95 via-black/90 to-[#8a2be2]/95" />
        </div>

        <div className="max-w-7xl mx-auto px-6 relative z-10">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-white mb-4">7starswin Network By The Numbers</h2>
            <p className="text-white/80 text-lg">Join a thriving community of successful affiliate managers</p>
          </div>
          <div className="grid md:grid-cols-4 gap-8 text-center text-white">
            {[
              { value: "500+", label: "Active Managers", icon: Users },
              { value: "$2.5M+", label: "Monthly Payouts", icon: DollarSign },
              { value: "15K+", label: "Contracts Signed", icon: FileCheck },
              { value: "24/7", label: "Manager Support", icon: Award },
            ].map((stat, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, scale: 0.8 }}
                whileInView={{ opacity: 1, scale: 1 }}
                transition={{ duration: 0.5, delay: index * 0.1 }}
              >
                <div className="bg-white/10 backdrop-blur-lg rounded-2xl p-8 border border-white/20 hover:bg-white/15 transition-all">
                  <stat.icon className="w-12 h-12 mx-auto mb-4 text-white" />
                  <p className="text-5xl font-bold mb-2">{stat.value}</p>
                  <p className="text-white/80">{stat.label}</p>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-24 bg-gradient-to-br from-[#8a2be2] via-black to-[#8a2be2] relative overflow-hidden">
        <div className="absolute inset-0">
          <motion.div
            className="absolute top-0 left-0 w-96 h-96 bg-white/10 rounded-full blur-3xl"
            animate={{ x: [0, 100, 0], y: [0, 50, 0] }}
            transition={{ duration: 20, repeat: Infinity }}
          />
          <motion.div
            className="absolute bottom-0 right-0 w-96 h-96 bg-white/10 rounded-full blur-3xl"
            animate={{ x: [0, -100, 0], y: [0, -50, 0] }}
            transition={{ duration: 15, repeat: Infinity }}
          />
        </div>

        <div className="max-w-4xl mx-auto px-6 text-center relative z-10">
          <motion.div
            initial={{ opacity: 0, y: 30 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.8 }}
          >
            <h2 className="text-5xl md:text-6xl font-extrabold text-white mb-6">
              Ready to Join Our Network?
            </h2>
            <p className="text-white/90 text-xl mb-10 leading-relaxed">
              Start your journey as a 7starswin affiliate manager today. Competitive payouts, 
              professional support, and the tools you need to succeed.
            </p>
            <div className="flex flex-wrap gap-4 justify-center">
              <Link
                to="/nda-request"
                className="group bg-white hover:bg-gray-50 text-[#8a2be2] px-10 py-5 rounded-2xl font-bold transition-all shadow-2xl text-lg flex items-center gap-3"
              >
                Apply Now - It's Free
                <ArrowRight className="w-5 h-5 group-hover:translate-x-1 transition-transform" />
              </Link>
              <Link
                to="/login"
                className="bg-white/10 hover:bg-white/20 backdrop-blur-lg text-white px-10 py-5 rounded-2xl font-bold transition-all border-2 border-white/30 text-lg"
              >
                Manager Login
              </Link>
            </div>
            
            <div className="mt-12 flex items-center justify-center gap-8 text-white/80 flex-wrap">
              <div className="flex items-center gap-2">
                <CheckCircle className="w-5 h-5" />
                <span>No application fees</span>
              </div>
              <div className="flex items-center gap-2">
                <CheckCircle className="w-5 h-5" />
                <span>Quick 24-48h approval</span>
              </div>
              <div className="flex items-center gap-2">
                <CheckCircle className="w-5 h-5" />
                <span>Start earning immediately</span>
              </div>
            </div>
          </motion.div>
        </div>
      </section>

      <LegalFooter />
    </div>
  );
}