import { TrendingUp, Euro, Target, AlertCircle, Link as LinkIcon, Users as UsersIcon, CheckCircle, Upload, Bell } from 'lucide-react';
import { LineChart, Line, BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, ResponsiveContainer } from 'recharts';
import Sidebar from '../components/Sidebar';
import DashboardHeader from '../components/DashboardHeader';
import { useEffect, useState } from 'react';

export default function ManagerDashboard() {
  const [managerData, setManagerData] = useState({
    ftd: 0,
    deposits: 0,
    activePartners: 0,
    salary: 0,
  });

  const kpiData = [
    // Real KPI data will populate here from imported affiliate data
  ];

  const notifications = [
    // Real notifications will appear here
  ];

  // Load manager data from localStorage
  useEffect(() => {
    const savedData = localStorage.getItem('7starswin_manager_data');
    if (savedData) {
      const managers = JSON.parse(savedData);
      // In a real app, this would fetch data for the logged-in manager
      // For now, use the first manager or show 0s
      if (managers.length > 0) {
        const currentManager = managers[0]; // First manager for demo
        setManagerData({
          ftd: currentManager.ftd,
          deposits: currentManager.deposits,
          activePartners: currentManager.activePartners,
          salary: currentManager.salary,
        });
      }
    }
  }, []);

  return (
    <div className="flex min-h-screen bg-gray-950">
      <Sidebar role="manager" />
      <div className="flex-1 ml-64">
        <DashboardHeader title="Manager Dashboard" subtitle="Welcome back, Michael Chen" />
        
        <div className="p-8 space-y-6">
          {/* KPI Cards */}
          <div className="grid md:grid-cols-4 gap-6">
            <div className="bg-gradient-to-br from-blue-600/20 to-blue-800/20 backdrop-blur-lg border border-blue-500/30 rounded-2xl p-6 hover:scale-105 transition-transform">
              <div className="flex items-center justify-between mb-4">
                <div className="w-12 h-12 rounded-lg bg-blue-600/30 flex items-center justify-center">
                  <TrendingUp className="w-6 h-6 text-blue-400" />
                </div>
                <span className="text-emerald-400 text-sm font-medium">+12.5%</span>
              </div>
              <p className="text-gray-400 text-sm mb-1">Total FTD</p>
              <p className="text-white text-3xl font-bold">{managerData.ftd}</p>
              <p className="text-gray-500 text-xs mt-2">This month</p>
            </div>

            <div className="bg-gradient-to-br from-purple-600/20 to-purple-800/20 backdrop-blur-lg border border-purple-500/30 rounded-2xl p-6 hover:scale-105 transition-transform">
              <div className="flex items-center justify-between mb-4">
                <div className="w-12 h-12 rounded-lg bg-purple-600/30 flex items-center justify-center">
                  <UsersIcon className="w-6 h-6 text-purple-400" />
                </div>
                <span className="text-emerald-400 text-sm font-medium">+8.3%</span>
              </div>
              <p className="text-gray-400 text-sm mb-1">Active Partners</p>
              <p className="text-white text-3xl font-bold">{managerData.activePartners}</p>
              <p className="text-gray-500 text-xs mt-2">Total partners</p>
            </div>

            <div className="bg-gradient-to-br from-emerald-600/20 to-emerald-800/20 backdrop-blur-lg border border-emerald-500/30 rounded-2xl p-6 hover:scale-105 transition-transform">
              <div className="flex items-center justify-between mb-4">
                <div className="w-12 h-12 rounded-lg bg-emerald-600/30 flex items-center justify-center">
                  <Euro className="w-6 h-6 text-emerald-400" />
                </div>
                <span className="text-emerald-400 text-sm font-medium">+15.7%</span>
              </div>
              <p className="text-gray-400 text-sm mb-1">Total Deposits</p>
              <p className="text-white text-3xl font-bold">{managerData.deposits}K</p>
              <p className="text-gray-500 text-xs mt-2">This month</p>
            </div>

            <div className="bg-gradient-to-br from-amber-600/20 to-amber-800/20 backdrop-blur-lg border border-amber-500/30 rounded-2xl p-6 hover:scale-105 transition-transform">
              <div className="flex items-center justify-between mb-4">
                <div className="w-12 h-12 rounded-lg bg-amber-600/30 flex items-center justify-center">
                  <Euro className="w-6 h-6 text-amber-400" />
                </div>
                <span className="text-gray-400 text-sm">Monthly</span>
              </div>
              <p className="text-gray-400 text-sm mb-1">Current Salary</p>
              <p className="text-white text-3xl font-bold">{managerData.salary}</p>
              <p className="text-gray-500 text-xs mt-2">USD per month</p>
            </div>
          </div>

          <div className="grid md:grid-cols-3 gap-6">
            {/* Performance Charts */}
            <div className="md:col-span-2 bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="flex items-center justify-between mb-6">
                <h3 className="text-white text-xl font-bold">Monthly Performance</h3>
                <select className="bg-gray-700/50 border border-gray-600 rounded-lg px-4 py-2 text-white text-sm focus:outline-none focus:border-purple-500">
                  <option>Last 6 months</option>
                  <option>Last 12 months</option>
                  <option>This year</option>
                </select>
              </div>
              <ResponsiveContainer width="100%" height={300}>
                <LineChart data={kpiData}>
                  <CartesianGrid strokeDasharray="3 3" stroke="#374151" />
                  <XAxis dataKey="month" stroke="#9CA3AF" />
                  <YAxis stroke="#9CA3AF" />
                  <Tooltip
                    contentStyle={{
                      backgroundColor: '#1F2937',
                      border: '1px solid #374151',
                      borderRadius: '0.5rem',
                      color: '#fff',
                    }}
                  />
                  <Line type="monotone" dataKey="ftd" stroke="#8B5CF6" strokeWidth={3} />
                  <Line type="monotone" dataKey="deposits" stroke="#10B981" strokeWidth={3} />
                </LineChart>
              </ResponsiveContainer>
              <div className="flex items-center justify-center gap-6 mt-4">
                <div className="flex items-center gap-2">
                  <div className="w-3 h-3 rounded-full bg-purple-600"></div>
                  <span className="text-gray-400 text-sm">FTD</span>
                </div>
                <div className="flex items-center gap-2">
                  <div className="w-3 h-3 rounded-full bg-emerald-600"></div>
                  <span className="text-gray-400 text-sm">Deposits ($1K)</span>
                </div>
              </div>
            </div>

            {/* NDA Status Card */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="flex items-center gap-3 mb-4">
                <div className="w-10 h-10 rounded-lg bg-emerald-600/20 flex items-center justify-center">
                  <LinkIcon className="w-5 h-5 text-emerald-400" />
                </div>
                <h3 className="text-white text-lg font-bold">NDA Status</h3>
              </div>
              <div className="space-y-4">
                <div className="flex items-center justify-between">
                  <span className="text-gray-400 text-sm">Status</span>
                  <span className="px-3 py-1 rounded-lg bg-emerald-500/20 text-emerald-400 text-xs font-medium flex items-center gap-1">
                    <CheckCircle className="w-3 h-3" />
                    Approved
                  </span>
                </div>
                <div className="flex items-center justify-between">
                  <span className="text-gray-400 text-sm">Signed Date</span>
                  <span className="text-white text-sm">Feb 24, 2026</span>
                </div>
                <div className="flex items-center justify-between">
                  <span className="text-gray-400 text-sm">Expires</span>
                  <span className="text-white text-sm">Feb 24, 2029</span>
                </div>
                <button className="w-full mt-4 px-4 py-3 rounded-xl bg-purple-600 hover:bg-purple-700 text-white font-medium transition-colors">
                  View NDA Document
                </button>
              </div>
            </div>
          </div>

          <div className="grid md:grid-cols-2 gap-6">
            {/* Salary Information */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="flex items-center justify-between mb-6">
                <div className="flex items-center gap-3">
                  <div className="w-10 h-10 rounded-lg bg-emerald-600/20 flex items-center justify-center">
                    <Euro className="w-5 h-5 text-emerald-400" />
                  </div>
                  <h3 className="text-white text-lg font-bold">Salary Information</h3>
                </div>
                <button className="flex items-center gap-2 px-4 py-2 rounded-lg bg-purple-600 hover:bg-purple-700 text-white text-sm font-medium transition-colors">
                  <Upload className="w-4 h-4" />
                  Upload Info
                </button>
              </div>
              <div className="space-y-4">
                <div className="p-4 bg-gray-900/50 rounded-xl">
                  <p className="text-gray-400 text-sm mb-1">Current Monthly Salary</p>
                  <p className="text-white text-2xl font-bold">{managerData.salary}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div className="p-4 bg-gray-900/50 rounded-xl">
                    <p className="text-gray-400 text-sm mb-1">Last Payment</p>
                    <p className="text-white font-semibold">Jan 31, 2026</p>
                  </div>
                  <div className="p-4 bg-gray-900/50 rounded-xl">
                    <p className="text-gray-400 text-sm mb-1">Next Payment</p>
                    <p className="text-white font-semibold">Feb 28, 2026</p>
                  </div>
                </div>
                <div className="p-4 bg-blue-500/10 border border-blue-500/30 rounded-xl">
                  <p className="text-blue-300 text-sm">
                    💡 Upload your bank details or crypto wallet address for direct payments
                  </p>
                </div>
              </div>
            </div>

            {/* Notifications */}
            <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-10 h-10 rounded-lg bg-blue-600/20 flex items-center justify-center">
                  <Bell className="w-5 h-5 text-blue-400" />
                </div>
                <h3 className="text-white text-lg font-bold">Notifications</h3>
              </div>
              <div className="space-y-3">
                {notifications.map((notif) => (
                  <div
                    key={notif.id}
                    className="p-4 bg-gray-900/50 rounded-xl hover:bg-gray-900/70 transition-colors cursor-pointer"
                  >
                    <div className="flex items-start gap-3">
                      <div
                        className={`w-2 h-2 rounded-full mt-1.5 ${
                          notif.type === 'success'
                            ? 'bg-emerald-400'
                            : notif.type === 'warning'
                            ? 'bg-yellow-400'
                            : 'bg-blue-400'
                        }`}
                      ></div>
                      <div className="flex-1">
                        <p className="text-white text-sm">{notif.message}</p>
                        <p className="text-gray-500 text-xs mt-1">{notif.time}</p>
                      </div>
                    </div>
                  </div>
                ))}
              </div>
              <button className="w-full mt-4 px-4 py-2 rounded-lg bg-gray-700 hover:bg-gray-600 text-white text-sm font-medium transition-colors">
                View All Notifications
              </button>
            </div>
          </div>

          {/* Profile Section */}
          <div className="bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-6">
            <h3 className="text-white text-xl font-bold mb-6">Profile Summary</h3>
            <div className="grid md:grid-cols-4 gap-6">
              <div className="flex items-center gap-4">
                <div className="w-16 h-16 rounded-full bg-gradient-to-br from-purple-600 to-blue-600 flex items-center justify-center">
                  <span className="text-white font-bold text-xl">MC</span>
                </div>
                <div>
                  <p className="text-white font-semibold">Michael Chen</p>
                  <p className="text-gray-400 text-sm">Affiliate Manager</p>
                </div>
              </div>
              <div>
                <p className="text-gray-400 text-sm mb-1">Email</p>
                <p className="text-white text-sm">michael.chen@example.com</p>
              </div>
              <div>
                <p className="text-gray-400 text-sm mb-1">Nationality</p>
                <p className="text-white text-sm">Singapore</p>
              </div>
              <div>
                <p className="text-gray-400 text-sm mb-1">Member Since</p>
                <p className="text-white text-sm">January 2026</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}