import { useParams } from 'react-router';
import { Download, Shield, Lock, CheckCircle } from 'lucide-react';
import Sidebar from '../components/Sidebar';
import DashboardHeader from '../components/DashboardHeader';

export default function NDADocumentPage() {
  const { id } = useParams();

  const handleDownload = () => {
    // Mock download functionality
    alert('NDA Document downloaded successfully!');
  };

  return (
    <div className="flex min-h-screen bg-gray-950">
      <Sidebar role="admin" />
      <div className="flex-1 ml-64">
        <DashboardHeader title="NDA Document" subtitle="Auto-generated Non-Disclosure Agreement" />
        
        <div className="p-8">
          <div className="max-w-4xl mx-auto space-y-6">
            {/* Document Actions */}
            <div className="flex items-center justify-between bg-gray-800/50 backdrop-blur-lg border border-gray-700 rounded-2xl p-4">
              <div className="flex items-center gap-3">
                <div className="w-10 h-10 rounded-lg bg-emerald-600/20 flex items-center justify-center">
                  <CheckCircle className="w-5 h-5 text-emerald-400" />
                </div>
                <div>
                  <h3 className="text-white font-semibold">Document Status: Approved</h3>
                  <p className="text-gray-400 text-sm">Generated on February 24, 2026</p>
                </div>
              </div>
              <button
                onClick={handleDownload}
                className="flex items-center gap-2 px-6 py-3 rounded-xl bg-gradient-to-r from-purple-600 to-purple-700 hover:from-purple-700 hover:to-purple-800 text-white font-semibold shadow-lg shadow-purple-600/50"
              >
                <Download className="w-5 h-5" />
                Download PDF
              </button>
            </div>

            {/* Encrypted Badge */}
            <div className="flex items-center justify-center gap-4 py-4">
              <div className="flex items-center gap-2 text-emerald-400">
                <Lock className="w-5 h-5" />
                <span className="text-sm font-medium">256-bit Encrypted</span>
              </div>
              <div className="flex items-center gap-2 text-blue-400">
                <Shield className="w-5 h-5" />
                <span className="text-sm font-medium">Legally Binding</span>
              </div>
            </div>

            {/* NDA Document Preview */}
            <div className="bg-white rounded-2xl shadow-2xl p-12 text-gray-900">
              {/* Header */}
              <div className="text-center mb-12 pb-8 border-b-2 border-gray-300">
                <div className="flex items-center justify-center gap-3 mb-4">
                  <div className="w-16 h-16 rounded-xl bg-gradient-to-br from-purple-600 to-purple-800 flex items-center justify-center">
                    <span className="text-white font-bold text-2xl">7★</span>
                  </div>
                </div>
                <h1 className="text-4xl font-bold mb-2 text-purple-900">7starswin</h1>
                <p className="text-gray-600">Affiliate Management Platform</p>
              </div>

              {/* Document Title */}
              <div className="text-center mb-8">
                <h2 className="text-3xl font-bold mb-4">NON-DISCLOSURE AGREEMENT</h2>
                <p className="text-gray-600">Document ID: NDA-2026-{id}</p>
                <p className="text-gray-600">Effective Date: February 24, 2026</p>
              </div>

              {/* Document Content */}
              <div className="space-y-6 text-justify leading-relaxed">
                <section>
                  <h3 className="text-xl font-bold mb-3">1. PARTIES</h3>
                  <p className="mb-2">
                    This Non-Disclosure Agreement ("Agreement") is entered into on February 24, 2026, between:
                  </p>
                  <div className="ml-6 space-y-2">
                    <p><strong>"Company":</strong> 7starswin Ltd., a company incorporated under the laws of Malta</p>
                    <p><strong>"Affiliate Manager":</strong> Michael Chen, Nationality: Singapore</p>
                  </div>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">2. PURPOSE</h3>
                  <p>
                    The purpose of this Agreement is to protect confidential and proprietary information 
                    shared between the Company and the Affiliate Manager in connection with the affiliate 
                    management services provided by the Affiliate Manager for the Company's gaming and 
                    sports betting operations.
                  </p>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">3. CONFIDENTIAL INFORMATION</h3>
                  <p className="mb-2">
                    "Confidential Information" includes, but is not limited to:
                  </p>
                  <ul className="list-disc ml-6 space-y-1">
                    <li>Affiliate partner information and contact details</li>
                    <li>Commission structures and payment terms</li>
                    <li>Marketing strategies and campaigns</li>
                    <li>Business metrics, KPIs, and performance data</li>
                    <li>Technical specifications and proprietary systems</li>
                    <li>Financial information and forecasts</li>
                    <li>Customer data and player information</li>
                  </ul>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">4. OBLIGATIONS</h3>
                  <p className="mb-2">The Affiliate Manager agrees to:</p>
                  <ul className="list-disc ml-6 space-y-1">
                    <li>Maintain confidentiality of all Confidential Information</li>
                    <li>Use Confidential Information solely for authorized purposes</li>
                    <li>Not disclose Confidential Information to third parties without written consent</li>
                    <li>Implement reasonable security measures to protect Confidential Information</li>
                    <li>Return or destroy all Confidential Information upon termination</li>
                  </ul>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">5. KPI PERFORMANCE METRICS</h3>
                  <div className="bg-gray-100 p-4 rounded-lg">
                    <p className="mb-2"><strong>Prohibition Period Performance:</strong></p>
                    <div className="grid grid-cols-2 gap-4 mt-3">
                      <div>
                        <p className="text-sm text-gray-600">First Time Deposits (FTD)</p>
                        <p className="text-2xl font-bold text-purple-900">150</p>
                      </div>
                      <div>
                        <p className="text-sm text-gray-600">Partners</p>
                        <p className="text-2xl font-bold text-purple-900">25</p>
                      </div>
                      <div>
                        <p className="text-sm text-gray-600">Total Deposit</p>
                        <p className="text-2xl font-bold text-purple-900">$75,000</p>
                      </div>
                      <div>
                        <p className="text-sm text-gray-600">Prohibition Period</p>
                        <p className="text-2xl font-bold text-purple-900">90 days</p>
                      </div>
                    </div>
                  </div>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">6. COMPENSATION</h3>
                  <p>
                    Subject to satisfactory performance during the prohibition period and compliance with 
                    this Agreement, the Affiliate Manager shall be entitled to a monthly salary of 
                    <strong> $6,000 USD</strong> commencing after the prohibition period.
                  </p>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">7. TERM AND TERMINATION</h3>
                  <p>
                    This Agreement shall commence on the Effective Date and continue for a period of 
                    three (3) years unless terminated earlier by mutual written consent or for cause 
                    as specified herein.
                  </p>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">8. NON-COMPETE</h3>
                  <p>
                    During the term of this Agreement and for twelve (12) months thereafter, the Affiliate 
                    Manager shall not engage in any competing business activities or provide services to 
                    direct competitors of the Company without prior written consent.
                  </p>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">9. GOVERNING LAW</h3>
                  <p>
                    This Agreement shall be governed by and construed in accordance with the laws of Malta, 
                    without regard to its conflict of law provisions.
                  </p>
                </section>

                <section>
                  <h3 className="text-xl font-bold mb-3">10. ENTIRE AGREEMENT</h3>
                  <p>
                    This Agreement constitutes the entire agreement between the parties and supersedes all 
                    prior understandings and agreements, whether written or oral, relating to the subject 
                    matter hereof.
                  </p>
                </section>
              </div>

              {/* Signatures */}
              <div className="mt-12 pt-8 border-t-2 border-gray-300">
                <div className="grid md:grid-cols-2 gap-8">
                  <div>
                    <h4 className="font-bold mb-4">FOR THE COMPANY:</h4>
                    <div className="space-y-2">
                      <div className="border-b-2 border-gray-400 pb-2">
                        <p className="font-semibold text-purple-900 italic text-xl">John Doe</p>
                      </div>
                      <p className="text-sm text-gray-600">Name: John Doe</p>
                      <p className="text-sm text-gray-600">Title: CEO, 7starswin Ltd.</p>
                      <p className="text-sm text-gray-600">Date: February 24, 2026</p>
                    </div>
                  </div>
                  <div>
                    <h4 className="font-bold mb-4">AFFILIATE MANAGER:</h4>
                    <div className="space-y-2">
                      <div className="border-b-2 border-gray-400 pb-2">
                        <p className="font-semibold text-purple-900 italic text-xl">Michael Chen</p>
                      </div>
                      <p className="text-sm text-gray-600">Name: Michael Chen</p>
                      <p className="text-sm text-gray-600">Nationality: Singapore</p>
                      <p className="text-sm text-gray-600">Date: February 24, 2026</p>
                    </div>
                  </div>
                </div>
              </div>

              {/* Legal Footer */}
              <div className="mt-12 pt-6 border-t border-gray-300">
                <div className="bg-yellow-50 border border-yellow-300 rounded-lg p-4">
                  <p className="text-xs text-gray-700 leading-relaxed">
                    <strong>⚠️ LEGAL DISCLAIMER:</strong> This document is a template generated for 
                    administrative purposes. While it contains standard NDA provisions, it should be 
                    reviewed by qualified legal counsel before execution. This is not legal advice. 
                    Both parties are encouraged to seek independent legal advice before signing.
                  </p>
                </div>
              </div>
            </div>

            {/* Security Notice */}
            <div className="bg-purple-500/10 border border-purple-500/30 rounded-xl p-4">
              <p className="text-purple-300 text-sm flex items-center gap-2">
                <Lock className="w-4 h-4" />
                <strong>Document Security:</strong> This document is encrypted and stored securely. 
                All access is logged and monitored for compliance purposes.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
