/**
 * 7starswin Brand Color System
 * Official color codes for the HR + Legal + KPI Management System
 */

export const brandColors = {
  // Primary Brand Colors
  purpleDark: '#450693',    // Primary brand color - dark purple
  purpleBright: '#8C00FF',  // Accent color - bright vibrant purple
  pink: '#FF3F7F',          // Secondary accent - pink/magenta
  gold: '#FFC400',          // Highlights & awards - gold/yellow
  
  // Gradient Combinations
  gradients: {
    purpleToPurple: 'linear-gradient(135deg, #450693 0%, #8C00FF 100%)',
    purpleToPink: 'linear-gradient(135deg, #8C00FF 0%, #FF3F7F 100%)',
    pinkToGold: 'linear-gradient(135deg, #FF3F7F 0%, #FFC400 100%)',
    fullSpectrum: 'linear-gradient(135deg, #450693 0%, #8C00FF 33%, #FF3F7F 66%, #FFC400 100%)',
  },
  
  // Color with opacity variations
  purpleDarkOpacity: (opacity: number) => `rgba(69, 6, 147, ${opacity})`,
  purpleBrightOpacity: (opacity: number) => `rgba(140, 0, 255, ${opacity})`,
  pinkOpacity: (opacity: number) => `rgba(255, 63, 127, ${opacity})`,
  goldOpacity: (opacity: number) => `rgba(255, 196, 0, ${opacity})`,
} as const;

/**
 * Usage Examples:
 * 
 * 1. Inline styles:
 *    style={{ background: brandColors.purpleDark }}
 *    style={{ background: brandColors.gradients.purpleToPink }}
 * 
 * 2. With opacity:
 *    style={{ background: brandColors.purpleDarkOpacity(0.2) }}
 * 
 * 3. Tailwind classes (using arbitrary values):
 *    className="bg-[#450693]"
 *    className="border-[#8C00FF]"
 */
