// Utility to dynamically get CSS class for theme colors
export function getThemeClasses(baseClass: string, mode: 'site' | 'hr') {
  const colorMap = {
    // Background colors
    'bg-[#8a2be2]': mode === 'site' ? 'bg-[#8a2be2]' : 'bg-[#ff00d8]',
    'bg-[#7a1fd2]': mode === 'site' ? 'bg-[#7a1fd2]' : 'bg-[#e600c0]',
    
    // Text colors
    'text-[#8a2be2]': mode === 'site' ? 'text-[#8a2be2]' : 'text-[#ff00d8]',
    'text-purple-600': mode === 'site' ? 'text-purple-600' : 'text-[#ff00d8]',
    'text-purple-400': mode === 'site' ? 'text-purple-400' : 'text-[#ff00d8]',
    'text-purple-300': mode === 'site' ? 'text-purple-300' : 'text-[#ff00d8]',
    
    // Border colors
    'border-[#8a2be2]': mode === 'site' ? 'border-[#8a2be2]' : 'border-[#ff00d8]',
    'border-purple-500': mode === 'site' ? 'border-purple-500' : 'border-[#ff00d8]',
    
    // Shadow colors
    'shadow-[#8a2be2]/50': mode === 'site' ? 'shadow-[#8a2be2]/50' : 'shadow-[#ff00d8]/50',
    'shadow-purple-600/50': mode === 'site' ? 'shadow-purple-600/50' : 'shadow-[#ff00d8]/50',
  };
  
  return colorMap[baseClass as keyof typeof colorMap] || baseClass;
}
